import os


def get_all_files(directory):
    result = []
    for root, directories, files in os.walk(directory):
        for file in files:
            result.append(os.path.realpath(os.path.join(root, file)))
    return result


def get_all_directories(directory):
    result = []
    for root, directories, files in os.walk(directory):
        for directory in directories:
            result.append(os.path.realpath(os.path.join(root, directory)))
    return result


def read_file(file_name):
    with open(file_name) as f:
        result = f.read()
    return result


def update_keyword_args(args_defaults, kwargs):
    options = args_defaults
    options.update(kwargs)
    return options


def get_required_keyword_arg(name, kwargs):
    if name in kwargs:
        return kwargs[name]
    else:
        raise Exception("required keyword argument: '" + name + "' missing")


def extend_lists_in_keyword_args(kwargs, list_name, extensions):
    if not isinstance(extensions, list):
        extensions = [extensions]
    extended_list = []
    if list_name in kwargs.keys():
        extended_list = kwargs[list_name]
    extended_list.extend(extensions)
    kwargs[list_name] = extended_list
